const bcrypt = require('bcryptjs');
const db = require('./config/db');

async function checkLogin(email, password) {
    try {
        // Get database connection
        const connection = await db.getConnection();

        // Query to find user by email
        const [rows] = await connection.execute(
            'SELECT * FROM users WHERE email = ?', 
            [email]
        );

        // Release the connection
        connection.release();

        // Check if user exists
        if (rows.length === 0) {
            console.log('User not found');
            return;
        }

        const user = rows[0];

        // Log user details
        console.log('User Details:', {
            id: user.id,
            email: user.email,
            is_blocked: user.is_blocked,
            is_active: user.is_active
        });

        // Check password
        const isPasswordMatch = await bcrypt.compare(password, user.password);
        console.log('Password Match:', isPasswordMatch);

        // Check account status
        if (user.is_blocked) {
            console.log('User is blocked');
        }

        if (user.is_active === 0) {
            console.log('User is inactive');
        }
    } catch (error) {
        console.error('Error checking login:', error);
    } finally {
        await db.end();
    }
}

// Use the email and password from the login attempt
checkLogin('supp@css.com', 'bluegate');
