require('dotenv').config({ path: require('path').resolve(__dirname, '../../.env') });
const db = require('./config/db');

async function cleanupAllApprovals() {
    try {
        console.log('🧹 Starting cleanup of ALL approval data...');

        // Delete all operation invocations first (due to foreign key constraints)
        const [invocationResult] = await db.query('DELETE FROM operation_invocations');
        console.log(`✅ Deleted ${invocationResult.affectedRows} operation invocations`);

        // Delete all approval requests (both pending and approved)
        const [requestResult] = await db.query('DELETE FROM approval_requests');
        console.log(`✅ Deleted ${requestResult.affectedRows} approval requests`);

        // Delete workflow audit log entries
        const [auditResult] = await db.query('DELETE FROM workflow_audit_log');
        console.log(`✅ Deleted ${auditResult.affectedRows} audit log entries`);

        // Reset auto-increment counters
        await db.query('ALTER TABLE approval_requests AUTO_INCREMENT = 1');
        await db.query('ALTER TABLE operation_invocations AUTO_INCREMENT = 1');
        await db.query('ALTER TABLE workflow_audit_log AUTO_INCREMENT = 1');

        console.log('🎉 Complete cleanup completed successfully!');
        console.log('📋 All approval lists are now empty.');
        process.exit(0);
    } catch (error) {
        console.error('❌ Error during cleanup:', error);
        process.exit(1);
    }
}

cleanupAllApprovals();
