require('dotenv').config({ path: require('path').resolve(__dirname, '../../.env') });
const db = require('./config/db');

async function cleanupPendingData() {
    try {
        console.log('🧹 Starting cleanup of pending workflow data...');

        // Delete pending operation invocations
        const [invocationResult] = await db.query(
            'DELETE FROM operation_invocations WHERE status = ?',
            ['pending']
        );
        console.log(`✅ Deleted ${invocationResult.affectedRows} pending operation invocations`);

        // Delete pending approval requests
        const [requestResult] = await db.query(
            'DELETE FROM approval_requests WHERE status = ?',
            ['pending']
        );
        console.log(`✅ Deleted ${requestResult.affectedRows} pending approval requests`);

        // Delete workflow audit log entries (optional - uncomment if needed)
        // const [auditResult] = await db.query('DELETE FROM workflow_audit_log');
        // console.log(`✅ Deleted ${auditResult.affectedRows} audit log entries`);

        // Reset auto-increment counters (optional)
        await db.query('ALTER TABLE approval_requests AUTO_INCREMENT = 1');
        await db.query('ALTER TABLE operation_invocations AUTO_INCREMENT = 1');

        console.log('🎉 Cleanup completed successfully!');
        process.exit(0);
    } catch (error) {
        console.error('❌ Error during cleanup:', error);
        process.exit(1);
    }
}

cleanupPendingData();
