const Branch = require('../models/branchModel');

exports.getAllBranches = async(req, res) => {
    try {
        const branches = await Branch.findAll();
        res.json(branches);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.getBranchById = async(req, res) => {
    try {
        const branch = await Branch.findById(req.params.id);
        if (!branch) {
            return res.status(404).json({ message: 'Branch not found' });
        }
        res.json(branch);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.createBranch = async(req, res) => {
    try {
        const newBranch = await Branch.create(req.body);
        res.status(201).json(newBranch);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.updateBranch = async(req, res) => {
    try {
        const updated = await Branch.update(req.params.id, req.body);
        if (!updated) {
            return res.status(404).json({ message: 'Branch not found' });
        }
        res.json({ message: 'Branch updated successfully' });
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.deleteBranch = async(req, res) => {
    try {
        const deleted = await Branch.delete(req.params.id);
        if (!deleted) {
            return res.status(404).json({ message: 'Branch not found' });
        }
        res.json({ message: 'Branch deleted successfully' });
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};
