const Module = require('../models/moduleModel');

exports.getAllModules = async (req, res) => {
    try {
        const modules = await Module.findAll();
        res.json(modules);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.getModuleById = async (req, res) => {
    try {
        const module = await Module.findById(req.params.id);
        if (!module) {
            return res.status(404).json({ message: 'Module not found' });
        }
        res.json(module);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.createModule = async (req, res) => {
    try {
        const newModule = await Module.create(req.body);
        res.status(201).json(newModule);
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.updateModule = async (req, res) => {
    try {
        const updated = await Module.update(req.params.id, req.body);
        if (!updated) {
            return res.status(404).json({ message: 'Module not found' });
        }
        res.json({ message: 'Module updated successfully' });
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};

exports.deleteModule = async (req, res) => {
    try {
        const deleted = await Module.delete(req.params.id);
        if (!deleted) {
            return res.status(404).json({ message: 'Module not found' });
        }
        res.json({ message: 'Module deleted successfully' });
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};
