const permissionModel = require('../models/permissionModel');

// Get all permissions
exports.getAllPermissions = async(req, res) => {
    try {
        const permissions = await permissionModel.getAllPermissions();
        res.json(permissions);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Get a single permission by ID
exports.getPermissionById = async(req, res) => {
    try {
        const permission = await permissionModel.getPermissionById(req.params.id);
        if (!permission) return res.status(404).json({ message: "Permission not found" });
        res.json(permission);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Create a new permission
exports.createPermission = async(req, res) => {
    try {
        const { name, description, module_id } = req.body;
        const permissionId = await permissionModel.createPermission(name, description, module_id);
        res.status(201).json({ message: "Permission created successfully", permissionId });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Update permission details
exports.updatePermission = async(req, res) => {
    try {
        const { name, description, module_id } = req.body;
        await permissionModel.updatePermission(req.params.id, name, description, module_id);
        res.json({ message: "Permission updated successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Delete a permission
exports.deletePermission = async(req, res) => {
    try {
        await permissionModel.deletePermission(req.params.id);
        res.json({ message: "Permission deleted successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};