const roleModel = require('../models/roleModel');

// Get all roles
exports.getAllRoles = async(req, res) => {
    try {
        const roles = await roleModel.getAllRoles();
        res.json(roles);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Get a single role by ID
exports.getRoleById = async(req, res) => {
    try {
        const role = await roleModel.getRoleById(req.params.id);
        if (!role) return res.status(404).json({ message: "Role not found" });
        res.json(role);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Create a new role
exports.createRole = async(req, res) => {
    try {
        const { name, description, module_id, parent_role_id } = req.body;
        await roleModel.createRole(name, description, module_id, parent_role_id);
        res.status(201).json({ message: "Role created successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Update role details
exports.updateRole = async(req, res) => {
    try {
        const { name, description, module_id, parent_role_id } = req.body;
        await roleModel.updateRole(req.params.id, name, description, module_id, parent_role_id);
        res.json({ message: "Role updated successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Delete a role
exports.deleteRole = async(req, res) => {
    try {
        await roleModel.deleteRole(req.params.id);
        res.json({ message: "Role deleted successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};