const rolePermissionModel = require('../models/rolePermissionModel');

// Get all role-permission mappings
exports.getRolePermissions = async(req, res) => {
    try {
        const rolePermissions = await rolePermissionModel.getRolePermissions();
        res.json(rolePermissions);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Get permissions assigned to a specific role
exports.getPermissionsByRoleId = async(req, res) => {
    try {
        const permissions = await rolePermissionModel.getPermissionsByRoleId(req.params.roleId);
        if (!permissions.length) return res.status(404).json({ message: "No permissions assigned to this role" });
        res.json(permissions);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Assign permissions to a role
exports.assignPermissionsToRole = async(req, res) => {
    try {
        const { permissionIds, storeId, moduleId } = req.body;
        const roleId = req.params.roleId;

        if (!Array.isArray(permissionIds) || permissionIds.length === 0) {
            return res.status(400).json({ message: "Invalid permissionIds. It must be a non-empty array." });
        }

        await rolePermissionModel.assignPermissionsToRole(roleId, permissionIds, storeId, moduleId);
        res.json({ message: "Permissions assigned successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Remove permissions from a role
exports.removePermissionsFromRole = async(req, res) => {
    try {
        const { permissionIds } = req.body;
        const roleId = req.params.roleId;

        if (!Array.isArray(permissionIds) || permissionIds.length === 0) {
            return res.status(400).json({ message: "Invalid permissionIds. It must be a non-empty array." });
        }

        await rolePermissionModel.removePermissionsFromRole(roleId, permissionIds);
        res.json({ message: "Permissions removed successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};