const mysql = require('mysql2/promise');

// Get all stores (public endpoint - no auth required for reading)
// Reads from Supply Chain database where stores table is located
exports.getStores = async(req, res) => {
    let connection;
    try {
        // Connect to Supply Chain database to read stores
        connection = await mysql.createConnection({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || 'root',
            database: process.env.SUPPLYCHAIN_DB_NAME || 'hybrid_supply_chain',
            port: process.env.DB_PORT || 3306
        });

        const [stores] = await connection.execute(
            'SELECT id, name, code, location, address, status FROM stores WHERE status = ? ORDER BY name',
            ['active']
        );

        res.status(200).json({
            success: true,
            data: stores
        });
    } catch (err) {
        console.error('Error fetching stores:', err);
        res.status(500).json({
            success: false,
            message: 'Failed to fetch stores',
            error: err.message
        });
    } finally {
        if (connection) {
            await connection.end();
        }
    }
};

