const userPermissionModel = require('../models/userPermissionModel');

// Get all user-permission mappings
exports.getUserPermissions = async(req, res) => {
    try {
        const userPermissions = await userPermissionModel.getUserPermissions();
        res.json(userPermissions);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Get permissions assigned to a specific user
exports.getPermissionsByUserId = async(req, res) => {
    try {
        const permissions = await userPermissionModel.getPermissionsByUserId(req.params.userId);
        if (!permissions.length) return res.status(404).json({ message: "No permissions assigned to this user" });
        res.json(permissions);
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Assign permissions directly to a user
exports.assignPermissionsToUser = async(req, res) => {
    try {
        const { permissionIds } = req.body;
        const userId = req.params.userId;

        if (!Array.isArray(permissionIds) || permissionIds.length === 0) {
            return res.status(400).json({ message: "Invalid permissionIds. It must be a non-empty array." });
        }

        await userPermissionModel.assignPermissionsToUser(userId, permissionIds);
        res.json({ message: "Permissions assigned successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};

// Remove permissions from a user
exports.removePermissionsFromUser = async(req, res) => {
    try {
        const { permissionIds } = req.body;
        const userId = req.params.userId;

        if (!Array.isArray(permissionIds) || permissionIds.length === 0) {
            return res.status(400).json({ message: "Invalid permissionIds. It must be a non-empty array." });
        }

        await userPermissionModel.removePermissionsFromUser(userId, permissionIds);
        res.json({ message: "Permissions removed successfully" });
    } catch (error) {
        res.status(500).json({ error: error.message });
    }
};