module.exports = function serviceAuth(req, res, next) {
    const token = req.headers['x-service-token'];
    if (!token) {
        return res.status(401).json({ message: 'Missing service token' });
    }
    const expected = process.env.NOTIFICATION_SERVICE_TOKEN || 'default-token';
    if (token !== expected) {
        return res.status(403).json({ message: 'Invalid service token' });
    }
    next();
}



