-- Create super_admins table
CREATE TABLE IF NOT EXISTS super_admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255) NOT NULL UNIQUE,
    email VARCHAR(255) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    name VARCHAR(255) NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    last_login DATETIME,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default super admin (password: admin123)
INSERT INTO super_admins (username, email, password, name)
VALUES ('superadmin', 'superadmin@hybrid.com', '$2a$10$RuPW/aMEFn9DXmxVxmO9Lue2ZDoNMBG1xx0XtUtvDtAR/H9U8LAsW', 'Super Administrator');
