const db = require('../services/dbService');

class Branch {
    static async findAll() {
        const [rows] = await db.query('SELECT * FROM branches ORDER BY name');
        return rows;
    }

    static async findById(id) {
        const [rows] = await db.query('SELECT * FROM branches WHERE id = ?', [id]);
        return rows[0];
    }

    static async create(branchData) {
        const {
            name,
            code,
            location,
            address,
            contact_person,
            contact_phone,
            contact_email,
            status = 'active'
        } = branchData;

        const result = await db.query(
            `INSERT INTO branches (name, code, location, address, contact_person, contact_phone, contact_email, status) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?)`, [name, code, location, address, contact_person, contact_phone, contact_email, status]
        );

        return { id: result.insertId, ...branchData };
    }

    static async update(id, branchData) {
        const {
            name,
            code,
            location,
            address,
            contact_person,
            contact_phone,
            contact_email,
            status
        } = branchData;

        const result = await db.query(
            `UPDATE branches 
             SET name = ?, code = ?, location = ?, address = ?, contact_person = ?, 
                 contact_phone = ?, contact_email = ?, status = ?, updated_at = CURRENT_TIMESTAMP
             WHERE id = ?`, [name, code, location, address, contact_person, contact_phone, contact_email, status, id]
        );

        return result.affectedRows > 0;
    }

    static async delete(id) {
        // We'll perform a soft delete by setting the status to 'inactive'
        const result = await db.query(
            'UPDATE branches SET status = "inactive", updated_at = CURRENT_TIMESTAMP WHERE id = ?', [id]
        );
        return result.affectedRows > 0;
    }
}

module.exports = Branch;
