const db = require('../config/db');

// Get all permissions
const getAllPermissions = async() => {
    const [permissions] = await db.execute("SELECT * FROM permissions");
    return permissions;
};

// Get a permission by ID
const getPermissionById = async(id) => {
    const [permissions] = await db.execute("SELECT * FROM permissions WHERE id = ?", [id]);
    return permissions[0];
};

// Create a new permission
const createPermission = async(name, description, module_id) => {
    const [result] = await db.execute(
        "INSERT INTO permissions (name, description, module_id) VALUES (?, ?, ?)", [name, description, module_id]
    );
    return result.insertId;
};

// Update permission details
const updatePermission = async(id, name, description, module_id) => {
    await db.execute(
        "UPDATE permissions SET name = ?, description = ?, module_id = ? WHERE id = ?", [name, description, module_id, id]
    );
};

// Delete a permission
const deletePermission = async(id) => {
    await db.execute("DELETE FROM permissions WHERE id = ?", [id]);
};

module.exports = { getAllPermissions, getPermissionById, createPermission, updatePermission, deletePermission };