const db = require('../config/db');

// Get all roles (module join is optional/not required for assignee listing)
const getAllRoles = async () => {
    const [roles] = await db.execute(`
        SELECT id, name, description, NULL as module_id, NULL as parent_role_id
        FROM roles 
        ORDER BY name ASC
    `);
    return roles;
};

// Get a role by ID
const getRoleById = async (id) => {
    const [rows] = await db.execute("SELECT * FROM roles WHERE id = ?", [id]);
    return rows[0];
};

// Create a new role
const createRole = async(name, description, module_id, parent_role_id) => {
    try {
        const [result] = await db.execute(
            `INSERT INTO roles (name, description, module_id, parent_role_id) VALUES (?, ?, ?, ?)`, [name, description, module_id, parent_role_id]
        );
        return result.insertId;
    } catch (error) {
        console.error("Create Role Error:", error.message);
        throw error;
    }
};

// Update role details
const updateRole = async(id, name, description, module_id, parent_role_id) => {
    await db.execute(
        "UPDATE roles SET name = ?, description = ?, module_id = ?, parent_role_id = ? WHERE id = ?", [name, description, module_id, parent_role_id, id]
    );
};

// Delete a role
const deleteRole = async(id) => {
    await db.execute("DELETE FROM roles WHERE id = ?", [id]);
};

module.exports = { getAllRoles, getRoleById, createRole, updateRole, deleteRole };