const db = require('../config/db');

// Get all permissions assigned to roles
const getRolePermissions = async() => {
    const [rolePermissions] = await db.execute(`
        SELECT rp.id, r.name AS role_name, p.name AS permission_name, r.module_id 
        FROM role_permissions rp
        JOIN roles r ON rp.role_id = r.id
        JOIN permissions p ON rp.permission_id = p.id
    `);
    return rolePermissions;
};

// Get permissions for a specific role
const getPermissionsByRoleId = async(roleId) => {
    const [permissions] = await db.execute(`
        SELECT p.id, p.name, p.description, p.module_id 
        FROM permissions p
        JOIN role_permissions rp ON p.id = rp.permission_id
        WHERE rp.role_id = ?
    `, [roleId]);
    return permissions;
};

// Assign permissions to a role
const assignPermissionsToRole = async(roleId, permissionIds, storeId, moduleId) => {
    const values = permissionIds.map(permissionId => [roleId, permissionId, storeId, moduleId]);
    await db.query("INSERT INTO role_permissions (role_id, permission_id, store_id, module_id) VALUES ?", [values]);
};

// Remove permissions from a role
const removePermissionsFromRole = async(roleId, permissionIds) => {
    await db.query("DELETE FROM role_permissions WHERE role_id = ? AND permission_id IN (?)", [roleId, permissionIds]);
};

module.exports = { getRolePermissions, getPermissionsByRoleId, assignPermissionsToRole, removePermissionsFromRole };