const db = require('../config/db');

// Get super admin by username
const getSuperAdminByUsername = async(username) => {
    const [admins] = await db.execute(
        "SELECT * FROM super_admins WHERE username = ?", [username]
    );
    return admins.length > 0 ? admins[0] : null;
};

// Get super admin by email
const getSuperAdminByEmail = async(email) => {
    const [admins] = await db.execute(
        "SELECT * FROM super_admins WHERE email = ?", [email]
    );
    return admins.length > 0 ? admins[0] : null;
};

// Get super admin by ID
const getSuperAdminById = async(id) => {
    const [admins] = await db.execute(
        "SELECT * FROM super_admins WHERE id = ?", [id]
    );
    return admins.length > 0 ? admins[0] : null;
};

// Update last login time
const updateLastLogin = async(id) => {
    await db.execute(
        "UPDATE super_admins SET last_login = CURRENT_TIMESTAMP WHERE id = ?", [id]
    );
};

// Change password
const changePassword = async(id, hashedPassword) => {
    await db.execute(
        "UPDATE super_admins SET password = ? WHERE id = ?", [hashedPassword, id]
    );
};

// Update super admin profile
const updateSuperAdmin = async(id, name, email) => {
    await db.execute(
        "UPDATE super_admins SET name = ?, email = ? WHERE id = ?", [name, email, id]
    );
};

module.exports = {
    getSuperAdminByUsername,
    getSuperAdminByEmail,
    getSuperAdminById,
    updateLastLogin,
    changePassword,
    updateSuperAdmin
};
