const db = require('../config/db');

// Get all permissions assigned to users
const getUserPermissions = async() => {
    const [userPermissions] = await db.execute(`
        SELECT up.id, u.name AS user_name, p.name AS permission_name, p.module_id 
        FROM user_permissions up
        JOIN users u ON up.user_id = u.id
        JOIN permissions p ON up.permission_id = p.id
    `);
    return userPermissions;
};

// Get permissions for a specific user
const getPermissionsByUserId = async(userId) => {
    const [permissions] = await db.execute(`
        SELECT p.id, p.name, p.description, p.module_id 
        FROM permissions p
        JOIN user_permissions up ON p.id = up.permission_id
        WHERE up.user_id = ?
    `, [userId]);
    return permissions;
};

// Assign permissions directly to a user
const assignPermissionsToUser = async(userId, permissionIds) => {
    const values = permissionIds.map(permissionId => [userId, permissionId]);
    await db.query("INSERT INTO user_permissions (user_id, permission_id) VALUES ?", [values]);
};

// Remove permissions from a user
const removePermissionsFromUser = async(userId, permissionIds) => {
    await db.query("DELETE FROM user_permissions WHERE user_id = ? AND permission_id IN (?)", [userId, permissionIds]);
};

module.exports = { getUserPermissions, getPermissionsByUserId, assignPermissionsToUser, removePermissionsFromUser };