const mysql = require('mysql2/promise');

async function resetDatabase() {
  const connection = await mysql.createConnection({
    host: '127.0.0.1',
    user: 'root',
    password: 'root',
    database: 'hybrid_users',
    port: 3306
  });

  try {
    console.log('Dropping existing tables...');

    // Drop tables with foreign keys first
    const tablesToDrop = [
      'user_permissions',
      'role_permissions',
      'role_modules',
      'messages',
      'conversation_participants',
      'conversations',
      'notifications',
      'pending_operations',
      'delegations',
      'escalations',
      'approval_step_progress',
      'approval_actions',
      'approval_requests',
      'approval_levels',
      'approval_workflows',
      'crud_operations_registry',
      'audit_logs',
      'logs',
      'workflows',
      'webhook_deliveries',
      'permissions',
      'users',
      'roles',
      'modules',
      'stores'
    ];

    for (const tableName of tablesToDrop) {
      try {
        await connection.execute(`DROP TABLE IF EXISTS \`${tableName}\``);
        console.log(`Dropped table: ${tableName}`);
      } catch (err) {
        console.log(`Could not drop ${tableName}: ${err.message}`);
      }
    }

    console.log('✅ All existing tables dropped');
  } catch (error) {
    console.error('❌ Error resetting database:', error.message);
  } finally {
    await connection.end();
  }
}

resetDatabase();
