const express = require('express');
const router = express.Router();
const logsMiddleware = require('../middleware/logsMiddleware');

// Import controllers
const approvalWorkflowCtrl = require('../controllers/approvalWorkflowController');
const approvalRequestCtrl = require('../controllers/approvalRequestController');

// Approval Workflow Routes
router.get('/workflows', logsMiddleware, approvalWorkflowCtrl.getAllWorkflows);
router.get('/workflows/stats', logsMiddleware, approvalWorkflowCtrl.getWorkflowStats);
router.get('/workflows/module', logsMiddleware, approvalWorkflowCtrl.getWorkflowsByModule);
router.get('/workflows/:id', logsMiddleware, approvalWorkflowCtrl.getWorkflowById);
router.post('/workflows', logsMiddleware, approvalWorkflowCtrl.createWorkflow);
router.put('/workflows/:id', logsMiddleware, approvalWorkflowCtrl.updateWorkflow);
router.delete('/workflows/:id', logsMiddleware, approvalWorkflowCtrl.deleteWorkflow);

// Approval Request Routes
router.get('/requests', logsMiddleware, approvalRequestCtrl.getAllRequests);
router.get('/requests/stats', logsMiddleware, approvalRequestCtrl.getApprovalStats);
router.get('/requests/pending', logsMiddleware, approvalRequestCtrl.getPendingApprovals);
router.get('/requests/:id', logsMiddleware, approvalRequestCtrl.getRequestById);
router.post('/requests', logsMiddleware, approvalRequestCtrl.createRequest);
router.post('/requests/:id/approve', logsMiddleware, approvalRequestCtrl.approveRequest);
router.post('/requests/:id/cancel', logsMiddleware, approvalRequestCtrl.cancelRequest);

// CRUD Operations Registry Routes
router.get('/operations', logsMiddleware, approvalRequestCtrl.getOperationsRegistry);
router.post('/operations', logsMiddleware, approvalRequestCtrl.registerOperation);
router.put('/operations/:id', logsMiddleware, approvalRequestCtrl.updateOperation);
router.delete('/operations/:id', logsMiddleware, approvalRequestCtrl.deleteOperation);

// Operation Queue routes
router.get('/operations/queue', logsMiddleware, approvalRequestCtrl.getQueuedOperations);
router.post('/operations/queue', logsMiddleware, approvalRequestCtrl.queueOperation);
router.get('/operations/queue/:id', logsMiddleware, approvalRequestCtrl.getQueuedOperationById);
router.post('/operations/queue/:id/execute', logsMiddleware, approvalRequestCtrl.forceExecuteOperation);

// Approval check route
router.get('/operations/check', logsMiddleware, approvalRequestCtrl.checkApprovalRequired);

module.exports = router;