const express = require('express');
const branchController = require('../controllers/branchController');
const authenticateSuperAdmin = require('../middleware/superAdminMiddleware');

const router = express.Router();

// All branch routes should be protected and only accessible by a super admin
router.use(authenticateSuperAdmin);

router.get('/', branchController.getAllBranches);
router.post('/', branchController.createBranch);
router.get('/:id', branchController.getBranchById);
router.put('/:id', branchController.updateBranch);
router.delete('/:id', branchController.deleteBranch);

module.exports = router;
