const express = require('express');
const router = express.Router();
const ChatController = require('../controllers/chatController');
const authenticateToken = require('../middleware/authMiddleware');

// Create separate router for public file access
const fileRouter = express.Router();

// Serve uploaded files (public access for images in authenticated conversations)
fileRouter.get('/:fileName', ChatController.serveFile);
fileRouter.get('/thumbnails/:fileName', ChatController.serveFile);

// Apply authentication middleware to all other chat routes
router.use(authenticateToken);

// Get user's conversations
router.get('/conversations', ChatController.getUserConversations);

// Create new conversation
router.post('/conversations', ChatController.createConversation);

// Get conversation messages
router.get('/conversations/:conversationId/messages', ChatController.getConversationMessages);

// Get conversation participants
router.get('/conversations/:conversationId/participants', ChatController.getConversationParticipants);

// Send message (REST fallback)
router.post('/messages', ChatController.sendMessage);

// Get unread message count
router.get('/conversations/:conversationId/unread', ChatController.getUnreadCount);

// Mark messages as read
router.post('/conversations/:conversationId/read', ChatController.markMessagesAsRead);

// Online status routes
router.get('/users/online', ChatController.getOnlineUsers);
router.post('/users/status', ChatController.updateUserStatus);
router.get('/users/:userId/status', ChatController.getUserStatus);

// User search for new chat
router.get('/users/search', ChatController.searchUsers);

// File upload routes
router.post('/upload', ChatController.getUploadMiddleware(), ChatController.uploadFile);
router.post('/messages/file', ChatController.sendFileMessage);

module.exports = { router, fileRouter };