const express = require('express');
const router = express.Router();
const crudOperationsCtrl = require('../controllers/crudOperationsController');
const logsMiddleware = require('../middleware/logsMiddleware');

// CRUD Operations Management Routes
router.get('/', logsMiddleware, crudOperationsCtrl.getAllOperations);
router.get('/stats', logsMiddleware, crudOperationsCtrl.getOperationsStats);
router.get('/module/:module', logsMiddleware, crudOperationsCtrl.getOperationsByModule);
router.get('/:id', logsMiddleware, crudOperationsCtrl.getOperationById);

router.post('/', logsMiddleware, crudOperationsCtrl.createOperation);
router.post('/bulk-import', logsMiddleware, crudOperationsCtrl.bulkImportOperations);

router.put('/:id', logsMiddleware, crudOperationsCtrl.updateOperation);
router.delete('/:id', logsMiddleware, crudOperationsCtrl.deleteOperation);

module.exports = router;