const { authenticate } = require('../middleware/authMiddleware');
const { authenticateSuperAdmin } = require('../middleware/superAdminMiddleware');

router.get('/', authenticate, moduleController.getAllModules);
router.post('/', authenticateSuperAdmin, moduleController.createModule);
router.get('/:id', authenticate, moduleController.getModuleById);
router.put('/:id', authenticateSuperAdmin, moduleController.updateModule);
router.delete('/:id', authenticateSuperAdmin, moduleController.deleteModule);

module.exports = router;
