const express = require('express');
const { getAllPermissions, getPermissionById, createPermission, updatePermission, deletePermission } = require('../controllers/permissionController');
const authenticateToken = require('../middleware/authMiddleware');

const router = express.Router();

router.get('/', authenticateToken, getAllPermissions);
router.get('/:id', authenticateToken, getPermissionById);
router.post('/', authenticateToken, createPermission);
router.put('/:id', authenticateToken, updatePermission);
router.delete('/:id', authenticateToken, deletePermission);

module.exports = router;