const express = require('express');
const { getRolePermissions, getPermissionsByRoleId, assignPermissionsToRole, removePermissionsFromRole } = require('../controllers/rolePermissionController');
const authenticateToken = require('../middleware/authMiddleware');

const router = express.Router();

router.get('/', authenticateToken, getRolePermissions);
router.get('/:roleId', authenticateToken, getPermissionsByRoleId);
router.post('/:roleId', authenticateToken, assignPermissionsToRole);
router.delete('/:roleId', authenticateToken, removePermissionsFromRole);

module.exports = router;