const express = require('express');
const { getAllRoles, getRoleById, createRole, updateRole, deleteRole } = require('../controllers/roleController');
const authenticateToken = require('../middleware/authMiddleware');

const router = express.Router();

router.get('/', authenticateToken, getAllRoles);
router.get('/:id', authenticateToken, getRoleById);
router.post('/', authenticateToken, createRole);
router.put('/:id', authenticateToken, updateRole);
router.delete('/:id', authenticateToken, deleteRole);

module.exports = router;