const express = require('express');
const superAdminController = require('../controllers/superAdminController');
const authenticateSuperAdmin = require('../middleware/superAdminMiddleware');

const router = express.Router();

// Public route for login
router.post('/login', superAdminController.login);

// Protected routes (require super admin authentication)
router.use(authenticateSuperAdmin);

router.get('/profile', superAdminController.getProfile);
router.put('/profile', superAdminController.updateProfile);
router.post('/change-password', superAdminController.changePassword);

// Branch management routes
const branchRoutes = require('./branchRoutes');
router.use('/branches', branchRoutes);

// Approval management routes
const approvalRoutes = require('./approvalRoutes');
router.use('/approvals', approvalRoutes);

module.exports = router;
