const express = require('express');
const userController = require('../controllers/userController');
const authenticateSuperAdmin = require('../middleware/superAdminMiddleware');

const router = express.Router();

// All user management routes for the superadmin should be protected
router.use(authenticateSuperAdmin);

router.get('/', userController.getAllUsers);
router.post('/', userController.createUser);
router.get('/:id', userController.getUserById);
router.put('/:id', userController.updateUser);
router.delete('/:id', userController.deleteUser);
router.post('/:id/change-password', userController.changePassword);

// Routes for blocking, unblocking, and resetting passwords
router.post('/:id/block', userController.blockUser);
router.post('/:id/unblock', userController.unblockUser);
router.post('/:id/reset-password', userController.resetPassword);

module.exports = router;
