const express = require('express');
const { getUserPermissions, getPermissionsByUserId, assignPermissionsToUser, removePermissionsFromUser } = require('../controllers/userPermissionController');
const authenticateToken = require('../middleware/authMiddleware');

const router = express.Router();

router.get('/', authenticateToken, getUserPermissions);
router.get('/:userId', authenticateToken, getPermissionsByUserId);
router.post('/:userId', authenticateToken, assignPermissionsToUser);
router.delete('/:userId', authenticateToken, removePermissionsFromUser);

module.exports = router;