const express = require('express');
const { getAllUsers, getUserById, createUser, updateUser, deleteUser, getUsernames, changePassword } = require('../controllers/userController');
const authenticateToken = require('../middleware/authMiddleware');

const router = express.Router();

// A regular user should only be able to get their own information or change their password.
// All other user management is handled by the superadmin.
router.get('/', authenticateToken, getAllUsers);
router.get('/:id', authenticateToken, getUserById);
router.put('/change-password/:id', authenticateToken, changePassword);

// Additional routes for user management
router.get('/module/:moduleId', authenticateToken, getAllUsers); // TODO: Implement getAllUsersByModule if needed
router.post('/usernames', getUsernames); // New route to get usernames by IDs - public for service-to-service calls

module.exports = router;