const fs = require('fs');
const path = require('path');
const db = require('../config/db');

async function runMigration() {
    try {
        console.log('Running super admin migration...');

        // Read the SQL file
        const sqlPath = path.join(__dirname, '../migrations/create-super-admin-table.sql');
        const sql = fs.readFileSync(sqlPath, 'utf8');

        // Split SQL statements by semicolon
        const statements = sql
            .split(';')
            .filter(statement => statement.trim() !== '');

        // Execute each statement
        for (const statement of statements) {
            await db.execute(statement);
            console.log('Executed SQL statement');
        }

        console.log('Super admin migration completed successfully');
    } catch (error) {
        console.error('Error running migration:', error);
    } finally {
        process.exit();
    }
}

runMigration();
