const db = require('../config/db');

const createApprovalTables = async () => {
    const createApprovalRequestsTableQuery = `
        CREATE TABLE IF NOT EXISTS approval_requests (
            id INT AUTO_INCREMENT PRIMARY KEY,
            requester_id INT NOT NULL,
            approver_id INT,
            module VARCHAR(50) NOT NULL,
            request_type VARCHAR(50) NOT NULL,
            status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
            request_details JSON,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )
    `;

    const createPendingOperationsTableQuery = `
        CREATE TABLE IF NOT EXISTS pending_operations (
            id INT AUTO_INCREMENT PRIMARY KEY,
            approval_request_id INT NOT NULL,
            operation_type VARCHAR(50) NOT NULL,
            operation_details JSON,
            status ENUM('pending', 'approved', 'rejected', 'executed') DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (approval_request_id) REFERENCES approval_requests(id) ON DELETE CASCADE
        )
    `;

    try {
        // Create approval_requests table first
        await db.execute(createApprovalRequestsTableQuery);
        console.log('Approval requests table created or already exists');

        // Then create pending_operations table
        await db.execute(createPendingOperationsTableQuery);
        console.log('Pending operations table created or already exists');
    } catch (error) {
        console.error('Error creating approval and pending operations tables:', error);
        throw error;
    }
};

module.exports = createApprovalTables;
