require('dotenv').config({ path: require('path').resolve(__dirname, '../../../.env') });
const db = require('../config/db');

async function ensureNotificationsTable() {
    const sql = `
        CREATE TABLE IF NOT EXISTS notifications (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            title VARCHAR(255) NOT NULL,
            message TEXT NOT NULL,
            link VARCHAR(512) NULL,
            type VARCHAR(50) DEFAULT 'info',
            priority VARCHAR(50) DEFAULT 'normal',
            icon VARCHAR(100) NULL,
            source_module VARCHAR(100) NULL,
            payload JSON NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            read_at TIMESTAMP NULL,
            INDEX idx_user_read (user_id, read_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
    `;

    await db.query(sql);
    console.log('✅ Notifications table ensured');
}

// If run directly, execute and exit; if imported, export the function
if (require.main === module) {
    ensureNotificationsTable()
        .then(() => process.exit(0))
        .catch(err => {
            console.error('Failed to create notifications table', err);
            process.exit(1);
        });
} else {
    module.exports = ensureNotificationsTable;
}
