const db = require('../config/db');

const createPendingOperationsTable = async () => {
    const createTableQuery = `
        CREATE TABLE IF NOT EXISTS pending_operations (
            id INT AUTO_INCREMENT PRIMARY KEY,
            approval_request_id INT NOT NULL,
            operation_type VARCHAR(50) NOT NULL,
            operation_details JSON,
            status ENUM('pending', 'approved', 'rejected', 'executed') DEFAULT 'pending',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (approval_request_id) REFERENCES approval_requests(id)
        )
    `;

    try {
        await db.execute(createTableQuery);
        console.log('Pending operations table created or already exists');
    } catch (error) {
        console.error('Error creating pending operations table:', error);
    }
};

module.exports = createPendingOperationsTable;
