const db = require('../config/db');
(async () => {
  try {
    await db.query(`CREATE TABLE IF NOT EXISTS workflows (
      id INT AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(255) NOT NULL,
      module VARCHAR(100) NOT NULL,
      operation VARCHAR(100) NOT NULL,
      description TEXT,
      active BOOLEAN DEFAULT TRUE,
      created_by VARCHAR(100),
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      INDEX idx_module_operation (module, operation),
      INDEX idx_active (active)
    )`);
    console.log('Ensured workflows');

    await db.query(`CREATE TABLE IF NOT EXISTS workflow_steps (
      id INT AUTO_INCREMENT PRIMARY KEY,
      workflow_id INT NOT NULL,
      step_order INT NOT NULL,
      mode ENUM('serial','parallel') DEFAULT 'serial',
      quorum INT DEFAULT 1,
      assignees JSON NOT NULL,
      sla_minutes INT,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      FOREIGN KEY (workflow_id) REFERENCES workflows(id) ON DELETE CASCADE,
      INDEX idx_workflow_order (workflow_id, step_order)
    )`);
    console.log('Ensured workflow_steps');

    await db.query(`CREATE TABLE IF NOT EXISTS workflow_policies (
      id INT AUTO_INCREMENT PRIMARY KEY,
      module VARCHAR(100) NOT NULL,
      operation VARCHAR(100) NOT NULL,
      condition_expr TEXT,
      workflow_id INT NOT NULL,
      priority INT DEFAULT 1,
      active BOOLEAN DEFAULT TRUE,
      created_by VARCHAR(100),
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      FOREIGN KEY (workflow_id) REFERENCES workflows(id) ON DELETE CASCADE,
      INDEX idx_module_operation_priority (module, operation, priority),
      INDEX idx_active (active)
    )`);
    console.log('Ensured workflow_policies');
    process.exit(0);
  } catch (e) {
    console.error('Error creating central tables:', e.message);
    process.exit(1);
  }
})();
