const bcrypt = require('bcryptjs');
const db = require('../config/db');

async function createCRMUser() {
    try {
        console.log('Setting up CRM user...');

        // First, ensure the CRM module exists
        const [modules] = await db.execute('SELECT id, name FROM modules WHERE name = ?', ['CRM']);
        let moduleId;

        if (modules.length === 0) {
            console.log('Creating CRM module...');
            const [result] = await db.execute('INSERT INTO modules (name, description) VALUES (?, ?)', ['CRM', 'Customer Relationship Management']);
            moduleId = result.insertId;
            console.log('CRM module created with ID:', moduleId);
        } else {
            moduleId = modules[0].id;
            console.log('CRM module already exists with ID:', moduleId);
        }

        // Check if CRM role exists
        const [roles] = await db.execute('SELECT id, name FROM roles WHERE name = ?', ['CRM Manager']);
        let roleId;

        if (roles.length === 0) {
            console.log('Creating CRM Manager role...');
            const [result] = await db.execute('INSERT INTO roles (name, description, module_id) VALUES (?, ?, ?)', ['CRM Manager', 'Customer Relationship Management Manager', moduleId]);
            roleId = result.insertId;
            console.log('CRM Manager role created with ID:', roleId);
        } else {
            roleId = roles[0].id;
            console.log('CRM Manager role already exists with ID:', roleId);
        }

        // Check if CRM user exists
        const [users] = await db.execute('SELECT id, email FROM users WHERE email = ?', ['cr@css.com']);

        if (users.length === 0) {
            console.log('Creating CRM user...');
            const hashedPassword = await bcrypt.hash('bluegate', 10);

            const [result] = await db.execute(
                'INSERT INTO users (name, email, password, role_id, module_id, username, store_id, phone_number) VALUES (?, ?, ?, ?, ?, ?, ?, ?)', ['CRM Manager', 'cr@css.com', hashedPassword, roleId, moduleId, 'crm_manager', 1, '+2341234567890']
            );

            console.log('CRM user created with ID:', result.insertId);
        } else {
            console.log('CRM user already exists with ID:', users[0].id);

            // Update the existing user to ensure correct module and role
            await db.execute(
                'UPDATE users SET role_id = ?, module_id = ? WHERE email = ?', [roleId, moduleId, 'cr@css.com']
            );
            console.log('CRM user updated with correct module and role');
        }

        console.log('✅ CRM user setup completed successfully!');
        console.log('📧 Email: cr@css.com');
        console.log('🔑 Password: bluegate');
        console.log('🏢 Module: CRM');
        console.log('👤 Role: CRM Manager');

    } catch (error) {
        console.error('❌ Error setting up CRM user:', error);
    } finally {
        process.exit(0);
    }
}

createCRMUser();