-- Migration script to add file upload support to existing chat messages table
-- Run this after updating the create-chat-tables.sql file

-- Add file attachment columns to messages table
ALTER TABLE messages
ADD COLUMN file_name VARCHAR(255) NULL COMMENT 'Original file name',
ADD COLUMN file_size BIGINT NULL COMMENT 'File size in bytes',
ADD COLUMN file_path VARCHAR(500) NULL COMMENT 'Server path to stored file',
ADD COLUMN file_url VARCHAR(500) NULL COMMENT 'Public URL to access file',
ADD COLUMN file_mime_type VARCHAR(100) NULL COMMENT 'MIME type of the file',
ADD COLUMN file_thumbnail_path VARCHAR(500) NULL COMMENT 'Path to thumbnail for images';

-- Add index for file queries
CREATE INDEX idx_messages_file_type ON messages(message_type);
CREATE INDEX idx_messages_file_name ON messages(file_name);

