const db = require('../config/db');

async function updateSupplyChainWorkflows() {
    try {
        console.log('🔄 Updating Supply Chain workflows to use consistent module name...');
        
        // Update all existing workflows to use 'supply_chain' as module name
        const [result] = await db.query(`
            UPDATE approval_workflows 
            SET module = 'supply_chain', updated_at = NOW()
            WHERE module IN ('supply_chain', 'finance', 'operations', 'accounts', 'quality_control')
            AND name LIKE '%Purchase Order%' 
               OR name LIKE '%Supplier%' 
               OR name LIKE '%Raw Material%' 
               OR name LIKE '%Vehicle%' 
               OR name LIKE '%Weighbridge%' 
               OR name LIKE '%Quality%' 
               OR name LIKE '%Payment%' 
               OR name LIKE '%Cost%' 
               OR name LIKE '%Stage%' 
               OR name LIKE '%End of Day%' 
               OR name LIKE '%Report%' 
               OR name LIKE '%Gate%' 
               OR name LIKE '%Registration%'
        `);

        console.log(`✅ Updated ${result.affectedRows} workflows to use 'supply_chain' module name`);

        // Verify the update
        const [workflows] = await db.query(`
            SELECT id, name, module, operation 
            FROM approval_workflows 
            WHERE module = 'supply_chain'
            ORDER BY id
        `);

        console.log('\n📋 Supply Chain Workflows in Database:');
        workflows.forEach(workflow => {
            console.log(`  - ID ${workflow.id}: ${workflow.name} (${workflow.operation})`);
        });

        console.log(`\n📊 Total Supply Chain workflows: ${workflows.length}`);

    } catch (error) {
        console.error('❌ Error updating workflows:', error);
    } finally {
        process.exit(0);
    }
}

// Run the update if this script is executed directly
if (require.main === module) {
    updateSupplyChainWorkflows();
}

module.exports = { updateSupplyChainWorkflows };
