const db = require('../config/db');

async function verifyCRMUser() {
    try {
        console.log('Verifying CRM user configuration...\n');

        // Check CRM user
        const [users] = await db.execute(`
            SELECT u.id, u.name, u.email, u.module_id, m.name as module_name, r.name as role_name 
            FROM users u 
            LEFT JOIN modules m ON u.module_id = m.id 
            LEFT JOIN roles r ON u.role_id = r.id 
            WHERE u.email = ?
        `, ['cr@css.com']);

        if (users.length > 0) {
            const user = users[0];
            console.log('✅ CRM User Found:');
            console.log(`   ID: ${user.id}`);
            console.log(`   Name: ${user.name}`);
            console.log(`   Email: ${user.email}`);
            console.log(`   Module ID: ${user.module_id}`);
            console.log(`   Module Name: ${user.module_name}`);
            console.log(`   Role: ${user.role_name}`);

            if (user.module_name === 'CRM') {
                console.log('\n🎉 CRM user is properly configured!');
                console.log('📧 Login with: cr@css.com');
                console.log('🔑 Password: bluegate');
                console.log('🚀 Should redirect to: /crm/dashboard');
            } else {
                console.log('\n⚠️  Warning: Module name is not "CRM"');
            }
        } else {
            console.log('❌ CRM user not found!');
        }

        // Test login simulation
        console.log('\n🔍 Testing login simulation...');
        const [testUsers] = await db.execute(`
            SELECT u.*, s.name as store_name, m.name as module_name
            FROM users u
            LEFT JOIN stores s ON u.store_id = s.id
            LEFT JOIN modules m ON u.module_id = m.id
            WHERE u.email = ? AND u.is_blocked = 0
        `, ['cr@css.com']);

        if (testUsers.length > 0) {
            const testUser = testUsers[0];
            console.log('✅ Login simulation successful:');
            console.log(`   Module Name: ${testUser.module_name}`);
            console.log(`   Store Name: ${testUser.store_name}`);
            console.log(`   User ID: ${testUser.id}`);
        } else {
            console.log('❌ Login simulation failed - user not found or blocked');
        }

    } catch (error) {
        console.error('❌ Error verifying CRM user:', error);
    } finally {
        process.exit(0);
    }
}

verifyCRMUser();