const db = require('../config/db');

const dbQuery = async(query, params) => {
    try {
        console.log(`🔍 Executing query: ${query.substring(0, 50)}...`);
        console.log(`🔍 Database config: ${JSON.stringify({host: process.env.DB_HOST || 'localhost', user: process.env.DB_USER || 'root', database: process.env.DB_NAME || 'hybrid_users'})}`);
        const [results] = await db.execute(query, params);
        return results;
    } catch (error) {
        console.error("Database query error:", error.message);
        console.error("Database query SQL:", query);
        console.error("Database query params:", params);
        throw error;
    }
};

module.exports = { dbQuery };