const db = require('../config/db');
const userModel = require('../models/userModel');

async function getUserDetails(userId) {
    try {
        console.log('Fetching user details for userId:', userId);
        
        const user = await userModel.getUserById(userId);
        console.log('User found:', user);
        
        if (!user) {
            console.log('No user found with ID:', userId);
            return null;
        }

        console.log('Fetching roles for role_id:', user.role_id);
        const [roles] = await db.execute('SELECT name FROM roles WHERE id = ?', [user.role_id]);
        console.log('Roles:', roles);

        console.log('Fetching role permissions for role_id:', user.role_id);
        const [rolePermissions] = await db.execute('SELECT p.name FROM permissions p JOIN role_permissions rp ON p.id = rp.permission_id WHERE rp.role_id = ?', [user.role_id]);
        console.log('Role Permissions:', rolePermissions);

        console.log('Fetching user permissions for user_id:', user.id);
        const [userPermissions] = await db.execute('SELECT p.name FROM permissions p JOIN user_permissions up ON p.id = up.permission_id WHERE up.user_id = ?', [user.id]);
        console.log('User Permissions:', userPermissions);

        const permissions = [...new Set([...rolePermissions.map(p => p.name), ...userPermissions.map(p => p.name)])];

        return {
            id: user.id,
            name: user.name,
            email: user.email,
            username: user.username,
            roles: roles.map(r => r.name),
            permissions,
            module_name: user.module_name || null,
            module_id: user.module_id || null,
            store_id: user.store_id || null,
            store_name: user.store_name || null,
            phone_number: user.phone_number || null,
            is_blocked: user.is_blocked || false
        };
    } catch (error) {
        console.error('Error in getUserDetails:', {
            userId,
            message: error.message,
            stack: error.stack,
            name: error.name
        });
        throw error;
    }
}

module.exports = { getUserDetails };
