let ioInstance = null;

function setIo(io) {
    ioInstance = io;
}

function getIo() {
    return ioInstance;
}

// Emit event to specific room or all connected clients
function emitToRoom(room, event, data) {
    if (ioInstance) {
        ioInstance.to(room).emit(event, data);
        console.log(`📡 Emitted ${event} to room ${room}:`, data);
    } else {
        console.warn('⚠️  Socket.IO instance not available for emitting events');
    }
}

// Emit event to all connected clients
function emitToAll(event, data) {
    if (ioInstance) {
        ioInstance.emit(event, data);
        console.log(`📡 Emitted ${event} to all clients:`, data);
    } else {
        console.warn('⚠️  Socket.IO instance not available for emitting events');
    }
}

module.exports = { setIo, getIo, emitToRoom, emitToAll };












