const mysql = require('mysql2/promise');

async function updateUsersTable() {
  const connection = await mysql.createConnection({
    host: '127.0.0.1',
    user: 'root',
    password: 'root',
    database: 'hybrid_users',
    port: 3306
  });

  try {
    console.log('Dropping existing users table...');
    await connection.execute('SET FOREIGN_KEY_CHECKS = 0');
    await connection.execute('DROP TABLE IF EXISTS users');
    await connection.execute('SET FOREIGN_KEY_CHECKS = 1');
    console.log('✅ Dropped existing users table');

    console.log('Creating new users table...');
    const createTableSQL = `CREATE TABLE \`users_temp\` (
      \`id\` int(11) NOT NULL,
      \`name\` varchar(255) NOT NULL,
      \`email\` varchar(255) NOT NULL,
      \`is_online\` tinyint(1) NOT NULL DEFAULT 0,
      \`last_seen_at\` timestamp NULL DEFAULT NULL,
      \`phone_number\` varchar(250) DEFAULT NULL,
      \`username\` varchar(250) DEFAULT NULL,
      \`password\` varchar(255) NOT NULL,
      \`role_id\` int(11) DEFAULT NULL,
      \`module_id\` int(11) NOT NULL,
      \`store\` varchar(250) DEFAULT NULL,
      \`store_id\` int(11) DEFAULT NULL,
      \`created_at\` timestamp NOT NULL DEFAULT current_timestamp(),
      \`is_blocked\` int(1) NOT NULL DEFAULT 0
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci`;

    await connection.execute(createTableSQL);
    console.log('✅ Created users table structure');

    console.log('Inserting user data...');
    const userData = [
      [2, 'Abdullah operation', 'operations@css.com', 0, '2025-10-18 15:26:00', null, 'operations', '$2a$10$Ay/aPwgRr//hm5AhgU5VOesAcseh3CsBANxi.53bt0NEM7mdGLNhG', 1, 2, null, 1, '2025-02-23 22:04:05', 0],
      [3, 'Abdullahi md', 'md@css.com', 0, '2025-10-17 17:03:37', null, 'md', '$2a$10$Ibm7NnBxL0oUlfoZUX7BMOFvf5r/4QIqaLHJZN3ExcnJZO7oZ7AUS', 1, 3, null, 1, '2025-02-23 22:05:46', 0],
      [4, 'Abdullahi accounts', 'accounts@css.com', 0, null, null, 'accounts', '$2a$10$Ibm7NnBxL0oUlfoZUX7BMOFvf5r/4QIqaLHJZN3ExcnJZO7oZ7AUS', 1, 4, null, 1, '2025-02-23 22:06:05', 0],
      [5, 'Abdullahi audit', 'audit@css.com', 0, null, null, 'audit', '$2a$10$qdalmMDooR3PuqhI8ok5A.7cowyu6cR.ML4BnedD/gxwWidobFgbu', 1, 5, null, 1, '2025-02-23 22:06:30', 0],
      [6, 'Abdullahi hr', 'hr@css.com', 1, null, null, 'hr', '$2a$10$rrTEo2mpH3MLKFDxpuZ9oOnxf2fTBF4f0ccnmyPDIpOevm3fx8I82', 1, 6, null, 1, '2025-02-23 22:06:57', 0],
      [7, 'Abdullahi cr', 'cr@css.com', 0, '2025-11-04 08:13:22', null, 'cr', '$2a$10$bI8O6qh7bo4MGyMEcSa83upVY70Z/2mBCe6F9.VHJlQUhF8a2cdQe', 20, 8, null, 1, '2025-02-23 22:07:11', 0],
      [8, 'Abdullahi supp', 'supp@css.com', 0, '2025-10-25 16:56:26', '08109315440', 'Abdul', '$2a$10$Ibm7NnBxL0oUlfoZUX7BMOFvf5r/4QIqaLHJZN3ExcnJZO7oZ7AUS', 1, 1, null, 1, '2025-02-24 03:45:07', 0],
      [9, 'Abdullahi gate', 'gate@css.com', 0, null, '08109315440', 'gate', '$2a$10$98Puzj2stpjGrjn.mCHYsOPj4RAnX9JBy5ATMSLGnWxdgoY20Yx..', 19, 1, null, 1, '2025-02-24 15:21:40', 0],
      [10, 'Abdullahi Ibrahim', 'aimaiabdu@gmail.com', 0, null, '08109315440', '', '$2a$10$1TatGgXmSDLwg39opKnSh.PxNRKTVinNVFpfIHm5ytFG2hFTQDSJy', 7, 1, null, 2, '2025-02-26 09:49:19', 0],
      [11, 'Umar Sanda', 'umarsanda@gmail.com', 0, null, '08109315440', '', '$2a$10$YJT5jFijZpy785m0rSA1meaQf8xpIxCIq3HEdC1B4uJadaBMv/tlq', 5, 1, null, 3, '2025-02-26 10:03:35', 0],
      [12, 'haidan Abdullahi', 'haidan@css.com', 0, null, '09034343419', '', '$2a$10$pdxiHv8cNYHRB7s9NLjD7.KwXXAHjK.qf/G5HR2Y.MbLyG5xnAqrC', 19, 1, null, 3, '2025-02-26 19:05:47', 0],
      [13, 'umar', 'umar@css.com', 0, null, '09162836212', '', '$2a$10$FEZLxBL8L9HsT5Gv/VPAju9.JMYmIbpmLpGQW4ojx4Rqc4IiRdLAC', 4, 1, null, 1, '2025-04-21 18:22:24', 0],
      [14, 'Test User', 'test@example.com', 0, null, '1234567890', 'testuser', '$2a$10$u0AZKtgVqO0VXa693/rsC.R4S1xikP4DEB6qDj37cFyjhC9yKQb4K', 1, 1, null, 1, '2025-08-10 21:19:56', 0],
      [15, 'Baba', 'baba@gmail.com', 0, null, '08109315440', '', '$2a$10$TpzkEOIuhr5IiXJUZ53tZ.uTLRQ4oqzybtc8VuKlVZnWaoqRf8KWW', 5, 1, null, 1, '2025-08-20 19:58:26', 0],
      [16, 'Ibrahim Hybrid', 'hybrid@gmail.com', 0, null, '08109315440', '', '$2a$10$LXrPEG9o17youz2Awd0AHuz4jZI3L5hBQflzwlD6MGgFTWOL7wEqe', 4, 1, null, 1, '2025-08-21 14:49:57', 0]
    ];

    for (const user of userData) {
      try {
        await connection.execute(
          'INSERT INTO `users_temp` (`id`, `name`, `email`, `is_online`, `last_seen_at`, `phone_number`, `username`, `password`, `role_id`, `module_id`, `store`, `store_id`, `created_at`, `is_blocked`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
          user
        );
      } catch (err) {
        console.log(`Warning: Could not insert user ${user[2]}: ${err.message}`);
      }
    }
    console.log('✅ Inserted user data');

    console.log('Setting up indexes...');
    await connection.execute('ALTER TABLE `users_temp` ADD PRIMARY KEY (`id`)');
    await connection.execute('ALTER TABLE `users_temp` ADD UNIQUE KEY `email` (`email`)');
    await connection.execute('ALTER TABLE `users_temp` MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17');
    console.log('✅ Set up indexes and auto-increment');

    // Rename table
    await connection.execute('RENAME TABLE `users_temp` TO `users`');
    console.log('✅ Renamed table to users');

    // Verify the data
    const [users] = await connection.execute('SELECT COUNT(*) as count FROM users');
    console.log(`✅ Total users: ${users[0].count}`);

  } catch (error) {
    console.error('❌ Error updating users table:', error.message);
  } finally {
    await connection.end();
  }
}

updateUsersTable();
