const { setIo } = require('./socket');

const setupWebSocket = (io) => {
    setIo(io);
    io.on('connection', (socket) => {
        console.log('New WebSocket connection:', socket.id);

        // Optional: client can join per-user room after authenticating
        socket.on('join_user_room', (userId) => {
            if (!userId) return;
            socket.join(`user:${userId}`);
        });

        // Join approval-related rooms
        socket.on('join_approvals', () => {
            socket.join('approvals');
            console.log(`Socket ${socket.id} joined approvals room`);
        });

        // Join procurement-related rooms
        socket.on('join_procurement', () => {
            socket.join('procurement');
            console.log(`Socket ${socket.id} joined procurement room`);
        });

        socket.on('disconnect', () => {
            console.log('WebSocket disconnected:', socket.id);
        });

        // Add more WebSocket event handlers as needed
    });
};

module.exports = setupWebSocket;
